/***********************************************************************
*
* AccessPriv uWindow.c
*
* Copyright (c)
* Apple Computer, Inc.  1989-1990
* All Rights Reserved.
*
* Developer Technical Support Sample Code
*
* This file contains the code which implements  
* windows in the AccessPriv program.
*
***********************************************************************/

#include <types.h>
#include <quickdraw.h>
#include <window.h>
#include <math.h>
#include <control.h>
#include <lineedit.h>
#include <stdfile.h>
#include <GSOS.h>
#include <dialog.h>
#include <memory.h>
#include <AppleShare.h>

#include "ap.h"

extern unsigned int         staggerCount, suppressErrors;
extern GrafPortPtr          windowList[SHORTINDEX];
extern handle               PrivCtrlHndls[7][3];
extern ptr                  mysubsttext[9];
extern GetAccessRightsRec   curaccessprivs;
extern SetAccessRightsRec   newaccessprivs;


extern GSString32Ptr    DirEntryNamePtr;
extern DirEntryRecGS    myGetDirEntryRec;

extern UserInfoRec      ASuserinfoRec;

extern GetPrivilegesRec ASgetprivsRec;
extern SetPrivilegesRec ASsetprivsRec;
extern ResultBuf255     ownernametoget, ownernametoset;
extern ResultBuf255     groupnametoget, groupnametoset;
extern ResultBuf255     usernametoget, usergroupnametoget, SFpathresult;
extern GSString255      foldertogetsetprivsof, volname;

extern GSString255Ptr   pathstrPtr;
extern char             hastheseprivs[60],blanks[255];

extern byte             power2[3];
extern int              userisowner;

extern multiReplyRecord myReply;


extern int              _toolErr;

#define MainWindowID    0x1000L
#define rWindParam1     0x800E

/************************************************************************
*
* drawThisWindow
*
* This routine draws the contents of all the windows.
*
************************************************************************/
void    drawThisWindow()
{
    DrawControls(GetPort());
}

/************************************************************************
*
* doCloseTop
*
* This routine closes the topmost window.  We do a little work to
* prevent the main window from being closed.
*
************************************************************************/
void    doCloseTop()
{
    unsigned int    k;
    GrafPortPtr     tempWin;

    tempWin = FrontWindow();
        
    /* Find the window entry, close the window, and zero the entry */
    /* start the count at 1 since we never close the main window */
    for (k = 1; k < NumWindows; k++) {
        if (tempWin == windowList[k]) {
            CloseWindow(tempWin);
            windowList[k] = NULL;
            break;
        }
    }
}

/***********************************************************************
*
* openThisWindow
*
* This routine either opens the specified window or brings it to the top
* if it is already open.
*
* If it is not open, we open it with NewWindow2 invisibly, adjust the window's
* location and then show and select the window.
*
************************************************************************/
void            openThisWindow(ctlid)
unsigned int    ctlid;
{
    GrafPortPtr     wptr;

    if (!(wptr = windowList[ctlid])) {
        windowList[ctlid] = wptr =
            NewWindow2(NULL, NULL, drawThisWindow, NULL, 2, ctlid+MainWindowID,
                       rWindParam1);
        if (ctlid < Prog1ID) {
            MoveWindow (50 + 8 * staggerCount, 50 + 8 * staggerCount, wptr);
            staggerCount++;
            staggerCount &= 0x0F;
        }
        ShowWindow(wptr);
        SelectWindow(wptr);             
    }
    else SelectWindow(wptr);
}
    
/*************************************************************************
*
* DefaultErrorWindow
*
* if _toolErr not zero, calls Error Window with default params
* Special case:  If suppressErrors is set, then don't show
* OS errors.
*
**************************************************************************/
void CheckToolOrSysError()
{
	unsigned int	err;

	err = _toolErr;
	if ((suppressErrors) && (err < 256)) err = 0;

    if (err) ErrorWindow(0, NULL, err);
}

/*************************************************************************
*
* MySFPfilter
*
* determines which files will be displayed, beyond selection in typelist
*
**************************************************************************/
pascal int MySFfilter(myDirEntryRecPtr)
DirEntryRecPtrGS myDirEntryRecPtr;
{
    GSString32Ptr myGSStringPtr;
    GSString32    myGSString;
    int entrylen;
    unsigned int flag, dbr;  /* result, data bank register value */
    
    dbr = SaveDB();                 /* make the data bank reg.   */
                                    /* point to globals, save it */

                                    /* get the entire dir entry record */
    myGetDirEntryRec.pCount = 17;
    myGetDirEntryRec.refNum = myDirEntryRecPtr->refNum;
    myGetDirEntryRec.flags = myDirEntryRecPtr->flags;
    myGetDirEntryRec.base = 1;
    myGetDirEntryRec.displacement = 0;
    myGetDirEntryRec.name = myDirEntryRecPtr->name;

    GetDirEntryGS(&myGetDirEntryRec);

    flag = noDisplay;
    if ((myGetDirEntryRec.fileType == 0x000f) &&
        (myGetDirEntryRec.fileSysID == appleShareFSID)) flag = displaySelect;
    RestoreDB(dbr);                 /* restore data bank reg. for return */
                                    /* to toolbox */
    return(flag);
}

/*************************************************************************
*
* ChooseFolder
*
* presents user with dialog to select folder to show/set privileges of
*
**************************************************************************/
void    ChooseFolder()
{
    int* namelenptr;
    SFMultiReplyNamesRec2Ptr myNamesRecPtr;
    static char prompt[] = "\pPick (accept) folder to examine privileges of.";
    ExpandPathRecGS myexpandpathrec;
    
                                         /* select folder type, any aux type */
    static SFTypeList2 mySFtypelist = {
    1,
    0x8000,
    0x000f,
    0L};

    (SFpathresult.bufString).length = 0;
    *((SFpathresult.bufString).text) = 0;
    SFMultiGet2(             /* user selection of folder to get/set privs of */
        120, 53,
        refIsPointer,
        prompt,
        MySFfilter,         
        &mySFtypelist,          
        &myReply
    );
    if (_toolErr) {
	    CheckToolOrSysError();
    	pathstrPtr->text[0] = (char) 0;
    	pathstrPtr->length = 0;
		return;
    }
    
    if (myReply.good) {
                                                    /* use 1st name returned */
        HLock(myReply.namesHandle);
        myNamesRecPtr =
            (SFMultiReplyNamesRec2Ptr) ((char *) (*myReply.namesHandle) + 2);           
        p2cstr(&(myNamesRecPtr->namestrlen));                                       
        strcpy(
            foldertogetsetprivsof.text,(char *)&(myNamesRecPtr->namestrlen));
        foldertogetsetprivsof.length =
            strlen((char *) (foldertogetsetprivsof.text));
        DisposeHandle(myReply.namesHandle);
                                                  /* multiget2 sets prefix 8 */
                                                  /* expand to full path     */
        myexpandpathrec.pCount = 3;
        myexpandpathrec.inputPath = &foldertogetsetprivsof;
        myexpandpathrec.outputPath = &SFpathresult;
        myexpandpathrec.flags = 0;
        ExpandPathGS(&myexpandpathrec);
        CheckToolOrSysError();
    }
	else suppressErrors = 1;
}

/**********************************************************************
*
* displayfoldervolumeanduser
*
* sets display of name user is logged in as, folder selected, and volume
*
**********************************************************************/
void displayfoldervolumeanduser()
{
    DevNumRecGS myDevNumRecPB;
    GSString32Ptr myGSStringPtr;
    int totalpathlen;
    char *acolon = ":";
    int pathlessvolstart;
    int volstrlen;
    int nextcolon;
    
    if (myReply.good)
    {
    volstrlen = strcspn(&(pathstrPtr->text[1]),acolon) + 1;
    volname.length = volstrlen;
    strncpy(volname.text,pathstrPtr->text,volstrlen); /* make vol string */
    volname.text[volstrlen] = (char) 0;
    myGSStringPtr = (GSString32Ptr) &(ASuserinfoRec.userName->bufString);
    myDevNumRecPB.pCount = 2;                    /* set up param block for & */
    myDevNumRecPB.devName = &volname;        /* issue GetDevNumber call  */
    GetDevNumberGS(&myDevNumRecPB);
    CheckToolOrSysError();
    ASuserinfoRec.deviceNum = myDevNumRecPB.devNum;  /* devNum from UserInfo  */
    FSTSpecific( &ASuserinfoRec);
    if (_toolErr) {
        myGSStringPtr->length = 0;
        CheckToolOrSysError();
    }
    myGSStringPtr->text[myGSStringPtr->length] = (char) 0;   /* term. string */
    totalpathlen = pathstrPtr->length;
    pathstrPtr->text[totalpathlen] = (char) 0;     /* term. path string      */
    if ((totalpathlen - volstrlen) > 32) {         /* does partial path fit? */
        pathlessvolstart = totalpathlen - 32;      /* no- not room in window */
                                                   /* use end part of it     */
        nextcolon = strcspn(&(pathstrPtr->text[pathlessvolstart]),acolon);
        pathlessvolstart = pathlessvolstart + nextcolon - 1;    /* str index */
        pathstrPtr->text[pathlessvolstart] = '.';
        pathstrPtr->text[pathlessvolstart+1] = '.';
    }
    else pathlessvolstart = volstrlen + 1;          /* yes- alt. str index   */
                                                    /* display partial path  */
    mysubsttext[0] = &(pathstrPtr->text[pathlessvolstart]);
    }
    else {                                          /* make these strings null */
    volname.length = 0;
    volname.text[0] = 0;
    volname.text[1] = 0;
    mysubsttext[0] = volname.text;
    (usernametoget.bufString).length = 0;
    (usernametoget.bufString).text[0] = 0;

    }
}

/*************************************************************************
*
* newownerorgroup
*
* Sets owner or group name for the file/folder
*
* inputs:  pointer to GS/OS result buffer to store name of owner/group,
*          handle to LineEdit control containing name of owner/group
*
************************************************************************/
void newownerorgroup(myRBPtr,myCtlRecHndl)
    ResultBuf255Ptr myRBPtr;
    CtlRecHndl myCtlRecHndl;
    
{
    GSString255Ptr myGSStringPtr;
    LERecHndl myLERecHndl;
    Handle myleLineHandle;
    int LElen;
    char *mycharptr;
    
    myLERecHndl = (LERecHndl) ((*myCtlRecHndl)->ctlData); /* hndl to LE rec  */
    myleLineHandle = LEGetTextHand(myLERecHndl);          /* hndl to its text*/
    LElen = LEGetTextLen(myLERecHndl);                    /* length of text  */
    myGSStringPtr = (GSString255Ptr) &(myRBPtr->bufString); /* str to copy to*/
    strncpy(myGSStringPtr->text,(*myleLineHandle),LElen);   /* copy LE text  */
    mycharptr = ((char *) (myGSStringPtr->text)) + LElen;   /* ptr to term.  */
    (*mycharptr) = 0;                                       /* term. CString */
    myGSStringPtr->length = LElen;                          /* set str len   */

}

/**************************************************************************
*
* dispownerorgroup
*
* sets display of owner/group name for the file/folder
*
* inputs:  pointer to GS/OS result buffer containing name of owner/group,
*          handle to LineEdit control to edit and display it in
*
*************************************************************************/
void dispownerorgroup(myRBPtr,myCtlRecHndl)
    ResultBuf255Ptr myRBPtr;
    CtlRecHndl myCtlRecHndl;
{
    GSString255Ptr myGSStringPtr;
    LERecHndl myLERecHndl;
    
    myGSStringPtr= (GSString255Ptr) &(myRBPtr->bufString); /* ptr to name str*/
    myLERecHndl= (LERecHndl) ((*myCtlRecHndl)->ctlData);   /* hndl to LE rec */
    LESetText(myGSStringPtr->text,myGSStringPtr->length,myLERecHndl);
    myGSStringPtr->text[myGSStringPtr->length] = (char) 0;
    InvalRect(&((*myLERecHndl)->leViewRect));              /* coerce display */
}

/**************************************************************************
*
* displayuserprivs
*
* decodes UserSummary field of access privs, sets display of list of them
*
**************************************************************************/
void displayuserprivs()
{
    int i;
    static char seefolderstr[] = "See folders";
    static char seefilerstr[] = "See files";
    static char makechangesstr[] = "Make changes";
    static char comma[] = ", ";
    static char none[] = "none";
    boolean otheritem;
    
    otheritem = false;                 /* track whether comma will be needed */
    /* hastheseprivs = privs; */
    (*hastheseprivs) = (char) 0;
    for (i = 0; i < 3; i++)            /* loop through each of 3 bits        */
    {
                                       /* does user have selected privs?     */
         if ((curaccessprivs.userSummary & power2[i]) != 0)
         switch(i)
        {
            case 0: strcat(hastheseprivs,seefolderstr); /* has seefolder priv*/
                    otheritem = true;
                    break;
            case 1: if (otheritem) strcat(hastheseprivs,comma); /* add comma?*/
                    strcat(hastheseprivs,seefilerstr);   /* has seefile priv */
                    otheritem = true;
                    break;
            case 2: if (otheritem) strcat(hastheseprivs,comma); /* add comma?*/
                                                 /* has priv to make changes */
                    strcat(hastheseprivs,makechangesstr);
                    break;
        }
    }
    if (*hastheseprivs == (char) 0) strcpy(hastheseprivs,none);
}

/************************************************************************
*
* setlockedctrl
*
* sets locked check box, or not, depending if file/folder is locked
*
*************************************************************************/
void setlockedctrl()
{
    FileInfoRecGS myFileInfoRecPB;
    int ifitslocked;
    
    myFileInfoRecPB.pCount = 3;                   /* set param block for and */
    myFileInfoRecPB.pathname = &foldertogetsetprivsof;  /* issue GetFileInfo */
    GetFileInfoGS(&myFileInfoRecPB);
    if (_toolErr) CheckToolOrSysError();
    else {
        if ((myFileInfoRecPB.access & (renameEnable | destroyEnable)) == 0) 
            ifitslocked = 1;
        else
            ifitslocked = 0;
        SetCtlValue(ifitslocked,PrivCtrlHndls[4][0]); /* set ctl accordingly */
    }
}

/***********************************************************************
*
* NewLockedSetting
*
* sets locked attributes of file/folder depending if user checked it locked
*
************************************************************************/
void NewLockedSetting()
{
    FileInfoRecGS myFileInfoRec;
    int ifitslocked;
    
    ifitslocked= (Word) GetCtlValue(PrivCtrlHndls[4][0]); /* inspect checkbox*/
    myFileInfoRec.pCount = 2;                        /* set param block for  */
    myFileInfoRec.pathname = &foldertogetsetprivsof; /* and issue GetFileInfo*/
    GetFileInfoGS(&myFileInfoRec);
    if (_toolErr) CheckToolOrSysError();
    else {
        if (ifitslocked == 0)
            myFileInfoRec.access =
                myFileInfoRec.access | renameEnable | destroyEnable;
        else
            myFileInfoRec.access = (myFileInfoRec.access & 0xff3f);
                                                   /* call SetFileInfo with  */
                                                   /* parms returned, access */
                                                   /* modified per check box */
        SetFileInfoGS(&myFileInfoRec);  
        CheckToolOrSysError();
    }
}

/************************************************************************
*
* CanMakeChanges
*
* redisplays privileges check box and text which may have been hidden
*
*************************************************************************/
void CanMakeChanges()
{
    int i, j;
    
    for (i = 0; i < 3; i++)              /* show the access priv check boxes */
    {
        for (j = 0; j < 3; j++)
        {
            ShowControl(PrivCtrlHndls[i][j]);
        }
    }
    ShowControl(PrivCtrlHndls[5][1]);    /* show the corresp. static text    */
    HideControl(PrivCtrlHndls[6][1]);    /* don't show the static text that  */
    HideControl(PrivCtrlHndls[6][2]);    /* subs for the LineEdit text       */
    ShowControl(PrivCtrlHndls[4][1]);    /* show the LineEdit text and       */
    ShowControl(PrivCtrlHndls[4][2]);
    HiliteControl(noHilite,PrivCtrlHndls[4][0]); /* display locked check box */
    HiliteControl(noHilite,PrivCtrlHndls[3][0]); /* undo button, and         */
    HiliteControl(noHilite,PrivCtrlHndls[3][1]); /* save button, undimmed    */
}

/*************************************************************************
*
* CannotMakeChanges
*
* hides privileges check boxes and text if user is not owner of file/folder
*
**************************************************************************/
void CannotMakeChanges()
{
    int i, j;

    for (i = 0; i < 3; i++)            /* hide the access priv check boxes */
    {
        for (j = 0; j < 3; j++)
        {
            HideControl(PrivCtrlHndls[i][j]);
        }
    }
    HideControl(PrivCtrlHndls[5][1]); /* hide the corresp. static text       */
    HideControl(PrivCtrlHndls[4][1]); /* don't show the the LineEdit boxes   */
    HideControl(PrivCtrlHndls[4][2]);                       
    ShowControl(PrivCtrlHndls[6][1]); /* show the static text that subs      */
    ShowControl(PrivCtrlHndls[6][2]); /* for the LineEdit text               */
                                      /* dim display of the locked check box */
    HiliteControl(inactiveHilite,PrivCtrlHndls[4][0]);
    HiliteControl(inactiveHilite,PrivCtrlHndls[3][0]);   /* undo button, and */
    HiliteControl(inactiveHilite,PrivCtrlHndls[3][1]);   /* save button      */
}

/************************************************************************
*
* CurrentPrivs
*
* displays information about user access for the file including privileges,
* check boxes to set the privileges, owner name, group name, name user is
* logged in as, etc.
*
*************************************************************************/
void CurrentPrivs()
{

    int privbit, i, j;
    LERecHndl myLERecHndl;
    GrafPortPtr  keepPort, topPort;
    
    FSTSpecific( &ASgetprivsRec);                  /* get the privs */
    if ((_toolErr) || !(myReply.good)) {
        CheckToolOrSysError();
                                  /* if error occurs, invalidate return vals */
        (ownernametoget.bufString).length = 0;
        (ownernametoget.bufString).text[0] = (char) 0;
        (groupnametoget.bufString).length = 0;
        (groupnametoget.bufString).text[0] = (char) 0;
        curaccessprivs = (GetAccessRightsRec) 0L;
    }
    else curaccessprivs = ASgetprivsRec.accessRights;       /* else save 'em */
    userisowner = curaccessprivs.userSummary & 0x80;
    
    keepPort = GetPort();
    topPort = FrontWindow();
    SetPort(topPort);
    dispownerorgroup(ASgetprivsRec.ownerName,(CtlRecHndl)PrivCtrlHndls[4][1]);
    dispownerorgroup(ASgetprivsRec.groupName,(CtlRecHndl)PrivCtrlHndls[4][2]);
    setlockedctrl();
    displayfoldervolumeanduser();
    displayuserprivs();
    if (userisowner)                                       /* is user owner? */
    {
        CanMakeChanges();              /* display user setable priv controls */
        for (i = 0; i < 3; i++)        /* set priv check boxes               */
        {
            for (j = 0; j < 3; j++)
            {
                 switch(i)
                {
                    case 0: privbit = (int)(curaccessprivs.world & power2[j]);
                            break;
                    case 1: privbit = (int)(curaccessprivs.group & power2[j]);
                            break;
                    case 2: privbit = (int)(curaccessprivs.owner & power2[j]);
                            break;
                }
            SetCtlValue(privbit,PrivCtrlHndls[i][j]);
            }
        }
    }
    else {
    CannotMakeChanges();         /* display priv controls , not user setable */
    }
    InvalRect(&(*topPort).portRect);           /* and cause it to be redrawn */
    SetPort(keepPort);
}

/*********************************************************************
*
* NewPrivs
*
* sets information about user access for the file including privileges, owner
* name, group name, and whether file/folder is locked
*
***********************************************************************/
void NewPrivs()
{

    int privbit, i, j,k;

    newaccessprivs.reserved = (Byte) 0;         /* set privs per check boxes */
    newaccessprivs.world = (Byte) (curaccessprivs.world & 0xf8);
    newaccessprivs.group = (Byte) (curaccessprivs.group & 0xf8);
    newaccessprivs.owner = (Byte) (curaccessprivs.owner & 0xf8);
    for (i = 0; i < 3; i++)
    {
        for (j = 0; j < 3; j++)
        {
             privbit = (Word) GetCtlValue(PrivCtrlHndls[i][j]);
             if (privbit != 0)
             switch(i)
            {
                case 0: newaccessprivs.world =
                            (Byte) (newaccessprivs.world | power2[j]);
                        break;
                case 1: newaccessprivs.group =
                            (Byte) (newaccessprivs.group | power2[j]);
                        break;
                case 2: newaccessprivs.owner =
                            (Byte) (newaccessprivs.owner | power2[j]);
                        break;
            }
        }
    }
    ASsetprivsRec.accessRights = newaccessprivs; /* setup parm block & privs */
    
    newownerorgroup(ASsetprivsRec.ownerName,(CtlRecHndl) PrivCtrlHndls[4][1]);
    newownerorgroup(ASsetprivsRec.groupName,(CtlRecHndl) PrivCtrlHndls[4][2]);
    FSTSpecific( &ASsetprivsRec);
    CheckToolOrSysError();
    NewLockedSetting();                     /* set locked bits per check box */
    CurrentPrivs();                       /* request and redisplay new privs */
}

/**********************************************************************
*
* setupCtrls
*
* Sets up handles to controls for use through out the program.
*
***********************************************************************/
void    setupCtrls()
{
    int i, j;
    unsigned long thisCtrlID;
    
    for (i = 0; i < 7; i++) /* loop through control handles, place into array*/
    {
        for (j = 0; j < 3; j++)
        {
                                          /* CheckFolderAllSee is 1st handle */
            thisCtrlID = i*3 + j + CheckFolderAllSee;           
            PrivCtrlHndls[i][j] =
                (handle) GetCtlHandleFromID(windowList[0],thisCtrlID);
        }
    }

    SetCtlParamPtr(mysubsttext);    /* establish pointers for subst. text    */
    CheckToolOrSysError();
                                    /* get 1st folder request and show privs */
    ChooseFolder();
    CurrentPrivs();
}

/**********************************************************************
*
* setupWindows
*
* Sets up windowList record for use through out the program.
*
***********************************************************************/
void    setupWindows()
{
    unsigned int    k;

    /* Zero out the entries in the window list. */
    for (k = 0; k < NumWindows; k++) windowList[k] = NULL;

    /* Open the main window */
    windowList[0] = NewWindow2(NULL, NULL, drawThisWindow, NULL, 2,
        MainWindowID, rWindParam1);
}
